/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.HighResolutionSeconds;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;

public class Seconds
extends TimeUnit {
    static final long serialVersionUID = 0L;
    private int secondsSerializedDataVersion = 1;
    public static final String UNIT_KEY = "dialog.timeParameter.seconds";
    public static final String DEFAULT_UNIT_STRING = "seconds";
    public static final String UNIT_ABBREVIATION = "s";

    public Seconds() {
        this.fHighMin = 0;
        this.fHighMax = 99;
        this.fHighInc = 1;
        this.fLowMin = 0;
        this.fLowMax = 95;
        this.fLowInc = 5;
    }

    public Seconds(TimeUnit timeUnit) {
        this.setMilliseconds(timeUnit.getMilliseconds());
    }

    public String getDefaultUnitString() {
        return UNIT_KEY;
    }

    public IntValueProperties getHigh() {
        return new IntValueProperties(this.fHighMin, this.fHighMax, this.fHighInc, (int)(this.fTime / 1000L), "error.dialog.invalidValue", "Invalid Value for Seconds.");
    }

    public int getHighValue() {
        return (int)(this.fTime / 1000L);
    }

    public int[] getLogoTime() {
        int time = this.getHighValue() * 20 + this.getLowValue() / 5;
        int[] lTime = new int[]{time / 256 | 0x40, time % 256};
        return lTime;
    }

    public IntValueProperties getLow() {
        return new IntValueProperties(this.fLowMin, this.fLowMax, this.fLowInc, this.getLowValue(), "error.dialog.invalidValueIncrement", "Invalid Value for Milliseconds.");
    }

    public int getLowValue() {
        return (int)(this.fTime % 1000L / 10L / 5L * 5L);
    }

    public int getTimeValue() {
        return this.getHighValue() * 100 + this.getLowValue();
    }

    public String getUnitAbbreviation() {
        return UNIT_ABBREVIATION;
    }

    public String getUnitKey() {
        return UNIT_KEY;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
    }

    public void setTime(int high, int low) {
        this.fTime = high * 1000 + low * 10;
    }

    public TimeUnit setTime(int value) {
        int rangedValue = Util.getValueInRange(0, 99990, value);
        this.setTime(0, rangedValue / 10);
        return this;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
    }

    public boolean isNoLossConvertibleTo(TimeUnit timeUnit) {
        return super.isNoLossConvertibleTo(timeUnit) || timeUnit instanceof HighResolutionSeconds;
    }

    public String getLowValueUnitKey() {
        return "dialog.timeParameter.milliseconds";
    }

    public String getLowValueUnitAbbreviation() {
        return "ms";
    }
}

